/*
 * Decompiled with CFR 0.152.
 */
package org.pokesplash.gts.Listing;

import com.google.gson.Gson;
import java.text.DecimalFormat;
import java.util.Date;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import net.minecraft.class_1799;
import net.minecraft.class_5250;
import org.pokesplash.gts.Gts;
import org.pokesplash.gts.api.provider.ListingAPI;
import org.pokesplash.gts.util.Utils;

public abstract class Listing<T> {
    protected String version = "2.0";
    protected UUID id = UUID.randomUUID();
    private UUID sellerUuid;
    private String sellerName;
    private double price;
    private long endTime;
    private boolean isPokemon;

    public Listing(UUID sellerUuid, String sellerName, double price, boolean isPokemon) {
        this.sellerUuid = sellerUuid;
        this.sellerName = sellerName;
        this.price = price;
        this.endTime = Gts.isDebugMode ? new Date().getTime() + 1000L * (long)Gts.debugTime : (Gts.config.getListingDuration() <= 0 ? -1L : new Date().getTime() + (long)Gts.config.getListingDuration() * 3600000L);
        this.isPokemon = isPokemon;
    }

    public boolean isPokemon() {
        return this.isPokemon;
    }

    public String getVersion() {
        return this.version;
    }

    public UUID getId() {
        return this.id;
    }

    public UUID getSellerUuid() {
        return this.sellerUuid;
    }

    public String getSellerName() {
        return this.sellerName;
    }

    public double getPrice() {
        return this.price;
    }

    public String getPriceAsString() {
        DecimalFormat df = new DecimalFormat("0.##");
        return df.format(this.price);
    }

    public long getEndTime() {
        return this.endTime;
    }

    public void setEndTime(long endTime) {
        this.endTime = endTime;
    }

    public void renewEndTime() {
        this.endTime = Gts.isDebugMode ? new Date().getTime() + 1000L * (long)Gts.debugTime : (Gts.config.getListingDuration() <= 0 ? -1L : new Date().getTime() + (long)Gts.config.getListingDuration() * 3600000L);
    }

    public abstract T getListing();

    public abstract boolean isListingValid();

    public boolean write(String filePath) {
        if (ListingAPI.getHighestPriority() != null) {
            ListingAPI.getHighestPriority().write(this);
            return true;
        }
        Gson gson = Utils.newGson();
        String data = gson.toJson((Object)this);
        CompletableFuture<Boolean> future = Utils.writeFileAsync(filePath, String.valueOf(this.getId()) + ".json", data);
        return future.join();
    }

    public boolean delete(String filePath) {
        if (ListingAPI.getHighestPriority() != null) {
            ListingAPI.getHighestPriority().delete(this);
            return true;
        }
        return Utils.deleteFile(filePath, String.valueOf(this.getId()) + ".json");
    }

    public void update(boolean isPokemon) {
        this.version = "2.0";
        this.isPokemon = isPokemon;
    }

    public abstract Listing deepClone();

    public abstract String getListingName();

    public boolean equals(Object o) {
        if (o instanceof Listing) {
            return ((Listing)o).getId().equals(this.getId());
        }
        return false;
    }

    public abstract class_5250 getDisplayName();

    public abstract String getUiTitle();

    public abstract class_1799 getIcon();
}

